﻿//Establish the Namespace if it doesnt already exist
if (typeof (GetConsultsForPatient) == "undefined")
    GetConsultsForPatient = {};

GetConsultsForPatient.Rows = [];

GetConsultsForPatient.SeeMore = '<font color="blue"> See More</font>';
GetConsultsForPatient.SeeLess = '<font color="blue"> See Less</font>';


GetConsultsForPatient.HookToTSAChange = function () {
    parent.Xrm.Page.getAttribute("mcs_relatedtsa").addOnChange(GetConsultsForPatient.RetrieveConsults);
}

GetConsultsForPatient.RefreshResults = function () {
    GetConsultsForPatient.RetrieveConsults();
}

GetConsultsForPatient.RetrieveConsults = function () {
    GetConsultsForPatient.HideAll();
    Xrm = parent.Xrm;
    var isGroup = Xrm.Page.getAttribute("mcs_groupappointment").getValue();
    if (isGroup)
        return;
    var patient = null;
    var patients = Xrm.Page.getAttribute("customers").getValue();
    if (patients != null)
        patient = patients[0];
    var patSiteObj = Xrm.Page.getAttribute("mcs_relatedsite")
    var patSite = patSiteObj != null && patSiteObj.getValue() != null ? patSiteObj.getValue()[0].id : null;
    var proSiteObj = Xrm.Page.getAttribute("mcs_relatedprovidersite");
    var proSite = proSiteObj != null && proSiteObj.getValue() != null ? proSiteObj.getValue()[0].id : null;
    var data = GetConsultsForPatient.CallIntegration(patient, proSite, patSite);
    if (data != null)
        GetConsultsForPatient.DisplayResults(data);
}

GetConsultsForPatient.CallIntegration = function(patientId, providerSiteId, patientSiteId) {
    //Determine whether to use Action or OData call to CRME_RetrieveMultiplePostStageRunner (like person search)
    var results;
    var filter = "cvt_IntegrationType/Value eq 917290001";
    if (patientId != null)
        filter += " and crme_contactid eq '" + patientId + "'";
    if (patientSiteId != null)
        filter += " and cvt_PatientSiteId eq '" + patientId + "'";
    if (providerSiteId != null)
        filter += " and cvt_ProviderSiteId eq '" + providerSiteId + "'"
    var integrationResults = null;
    CrmRestKit.ByQuery("crme_person", ['cvt_ConsultTitle', 'cvt_ConsultIEN', 'cvt_ConsultStatus', 'cvt_ConsultTimestamp', 'cvt_ConsultText', 'crme_url'], filter, false).
        done(function (data) {
                if (data != null && data.d != null && data.d.results != null) {
                    var results = data.d.results;
                    if (results.length == 0) {
                        GetConsultsForPatient.ShowWarningMessage("No Consults were found")
                    }
                    else {
                        integrationResults = results;
                    }
                }
                return null;
            }
        ).fail(function (err) {
            var friendlyError = "Failure in Get Consults For Patient: " + parent.MCS.cvt_Common.RestError(err);
            GetConsultsForPatient.ShowErrorMessage(friendlyError);
            return null;
        });
    return integrationResults;
}

GetConsultsForPatient.DisplayResults = function(data) {
    var table = $("#ConsultResultsTable");
    table.find("thead, tr, th").remove();
    table.find("tr:gt(0)").remove();
    if (data != null && data.length > 0)
    {
        if (data.length == 1 && GetConsultsForPatient.isFailure(data))
        {
            GetConsultsForPatient.ShowErrorMessage();
            return;
        }
        $("#ConsultResultsGrid").show();
        var headers = ['Title', 'IEN', 'TimeStamp', 'Status', 'Text', 'Location'];

        var thead = document.createElement('tr');

        for (var i = 0; i < headers.length; i++) {
            var th = document.createElement('th');
            th.className = "grid_title";
            th.appendChild(document.createTextNode(headers[i]));
            th.id = "th_" + headers[i].replace(' ', '');
            th.title = headers[i];
            th.scope = "col";
            thead.appendChild(th);
        }

        table.append(thead);

        for (var i = 0; i < data.length; i++) {
            var row = document.createElement('tr');
            row.id = i;
            
            var crmValues = GetConsultsForPatient.GetValues(data[i], row, i);
            for (var j = 0; j < headers.length; j++) {
                if (j == 0) {
                    var td = document.createElement('th');
                    td.scope = "row";
                }
                else {
                    var td = document.createElement('td');                    
                }

                td.id = "th_" + i + "_" + j + "_" + headers[j].replace(' ', '');
                td.title = crmValues[j];
                if (headers[j] == "Text" && row.getAttribute("cvt_ConsultText").length > 1000)
                {
                    var text = row.getAttribute("displayText");
                    //td.appendChild(document.createTextNode(text));
                    td.innerHTML = text + GetConsultsForPatient.SeeMore;
                    td.onclick = function () { GetConsultsForPatient.ToggleText(this, this.parentElement) };
                } else {
                    td.appendChild(document.createTextNode(crmValues[j]));
                }
                row.appendChild(td);
            }
            row.className = "grid_row";
            row.ondblclick = function () { GetConsultsForPatient.SetConsultValues(this); };
            table.append(row);
        }

        //force focus to message
        table.focus();
    }
    else
    {
        $("#warningDetails").text("");
        $("#warningDetails").append("No Consults were found for this station");
        $("#msgBoxNoDataReturned").show();
    }
}

GetConsultsForPatient.SetConsultValues = function (selectedRow) {
    var ien = selectedRow.getAttribute("cvt_ConsultIEN");

    var location = selectedRow.getAttribute("location").toLowerCase();
    if (location == "patient")
        parent.Xrm.Page.getAttribute("cvt_patconsultien").setValue(ien);
    else
        parent.Xrm.Page.getAttribute("cvt_proconsultien").setValue(ien);
    $("#selectedConsult").append("<br/>Added Consult with IEN: " + ien + " to appointment booking on " + location + " side.");
    $("#informUserConsultAdded").show();
    
    GetConsultsForPatient.RemoveOtherConsultsFromSameLocation(selectedRow.parentElement, selectedRow);
}

GetConsultsForPatient.ShowErrorMessage = function (errorMessage) {
    $("#errorDetails").text("");
    $("#errorDetails").append(errorMessage);

    $("#msgBoxSearchResultError").show();
    $("#msfBoxSearchResultError").focus();
}

GetConsultsForPatient.ShowWarningMessage = function (message) {
    $("#warningDetails").text("");
    $("#warningDetails").append(message);

    $("#msgBoxNoDataReturned").show();
}

GetConsultsForPatient.HideAll = function () {
    $("#msgBoxNoDataReturned").hide();
    $("#ConsultResultsGrid").hide();
    $("#msgBoxSearchResultError").hide();
    $("#msgBoxFailedValidation").hide();
    $("#msgBoxWorking").hide();
    
    

}

GetConsultsForPatient.GetValues = function (data, row, counter) {
    //var headers = ['Title', 'IEN', 'TimeStamp', 'Status', 'Text', crme_url(side)];
    var title = data.cvt_ConsultTitle;
    row.setAttribute("cvt_ConsultTitle", title);

    var ien = data.cvt_ConsultIEN;
    row.setAttribute("cvt_ConsultIEN", ien);

    var timeStamp = data.cvt_ConsultTimestamp;
    row.setAttribute("cvt_ConsultTimestamp", timeStamp);

    var status = data.cvt_ConsultStatus;
    row.setAttribute("cvt_ConsultStatus", status);

    var text = data.cvt_ConsultText;
    row.setAttribute("cvt_ConsultText", text);

    if (text.length > 1000) {
        var lessText = text.substring(0, 1000);
        row.setAttribute("displayText", lessText);
    }
    else
        var lessText = text;
    row.setAttribute("displayText", lessText);

    var side = data.crme_url
    row.setAttribute("location", side);

    row.setAttribute("status", "less");
    return [title, ien, timeStamp, status, text, side];
}

GetConsultsForPatient.ToggleText = function (cell, row) {
    if (row.getAttribute("status") == "less") {
        cell.innerHTML = row.getAttribute("cvt_ConsultText");
        cell.innerHTML += GetConsultsForPatient.SeeLess;
        row.setAttribute("status", "more");
    } else if (row.getAttribute("status") == "more") {
        cell.innerHTML = row.getAttribute("displayText");
        cell.innerHTML += GetConsultsForPatient.SeeMore;
        row.setAttribute("status", "less");
    }
}

GetConsultsForPatient.RemoveOtherConsultsFromSameLocation = function(table, row) {
    var isProvider = row.getAttribute("location").toLowerCase() == "provider";
    var tableRows = table.children;
//Skip header row, start with row index 1; use decrementer if a row has been removed to cancel out the table size change
    for (var i = 1; i < tableRows.length; i++) {
        var rowLocation = tableRows[i].getAttribute("location");
        if (isProvider) {
            if (rowLocation.toLowerCase() == "provider") {
                table.deleteRow(i--);
            }
        }
        else {
            if (rowLocation.toLowerCase() == "patient") {
                table.deleteRow(i--);
            }
        }
    }
}